#include <iostream>
#include <algorithm>

#define MAX_N 200000

unsigned long long a[MAX_N + 1];
unsigned long long K[MAX_N + 1];

unsigned long long coef[MAX_N];

void CalculateCoef(int n)
{
	n--;
	long long factU = 1;
	for (int i = 1; i <= n; ++i)	
		factU *= i;	
		
	coef[0] = 1;
	coef[n] = 1;
		
	long long factD1S = n / 2;
	long long factD2S = (n + 1) / 2;
	
	long long factD1 = 1;	
	long long factD2 = 1;	
	
	for (int i = 1; i <= n / 2; ++i)
		factD2 = (factD1 *= i);
		
	if (n % 2 == 1)
		factD2 *= (n + 1) / 2;
		
	for (int i = n / 2; i >= 1; --i)
	{
		long long k;
		coef[n - i] = coef[i] = factU / factD1 / factD2;
		factD1 /= factD1S--;
		factD2 *= factD2S++;
	}
}

int main()
{	
	long long unsigned N, T, C;
	scanf("%llu%llu%llu", &N, &T, &C);
	
	unsigned long long Cpow = 1;
	unsigned long long fact = std::min(T, N);	
	for (int i = 0; i <= std::abs((long long)T - (long long)N); ++i)
		Cpow *= C;
	
	for (int i = 0; i < N; ++i)	
		scanf("%llu", &a[i]);

	for (int i = 0; i < N; ++i)
		scanf("%llu", &K[i]);	
		
	K[0] = 1;		
	
	CalculateCoef(N + 1);
		
	unsigned long long sum = a[std::min(T, N)];	
	for (int i = std::min(T, N); i >= 1; --i)
	{		
		printf("fact=%llu coef=%llu Cpow=%llu\n", fact, coef[i - 1], Cpow);
		sum = sum * fact * K[i] + coef[i - 1] * Cpow * a[i - 1];
		Cpow *= C;	
		fact--;	
	}
			
	printf("%llu", sum);	
	
	return 0;
}